package com.elitesland.yst.production.pur.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.pur.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购对账单明细表
 *
 * @author chaofeng.xia
 * @date 2024/4/12 15:57
 */
@Data
@ApiModel(value = "PurAccountCheckDRpcDTO", description = "采购对账单明细表")

public class PurAccountCheckDRpcDTO extends BaseModelVO implements Serializable {

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("业务单据明细ID")
    private Long billDId;

    @ApiModelProperty("业务单据ID")
    private Long billId;

    @ApiModelProperty("对账单行号")
    private BigDecimal lineNo;

    @ApiModelProperty("中间表行号")
    private BigDecimal tblLineNo;

    @ApiModelProperty("单据类型")
    private String billDocType;

    @ApiModelProperty("对账类型")
    private String accountType;

    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("采购订单单据编号")
    private String poNo;

    @ApiModelProperty("品项ID")
    private Long itemId;
    private String itemCode;
    private String itemName;
    @ApiModelProperty("品项规格")
    private String itemSpec;
    @ApiModelProperty("商品SKU品类编号")
    private String itemCateCode;
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;
    @ApiModelProperty("品类(SPU)全路径名称")
    private String itemCateFullName;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("运输方式")
    private String transType;

    @ApiModelProperty("收货数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("收货数量2")
    private BigDecimal qty2;

    @ApiModelProperty("单位2")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("收货人员工ID")
    private Long recvEmpId;

    @ApiModelProperty("收货人名字")
    private String recvEmpName;

    @ApiModelProperty("发货日期")
    private LocalDateTime recvDate;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("配额分配金额(含税)")
    private BigDecimal partsAmtUse;

    @ApiModelProperty("配额分配金额(不含税)")
    private BigDecimal partsNetAmtUse;

    @ApiModelProperty("配额分配本币金额(含税)")
    private BigDecimal partsAmtLocalUse;

    @ApiModelProperty("配额分配本币金额(不含税)")
    private BigDecimal partsNetAmtLocalUse;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("采购结算对账单ID")
    private Long purAccountCheckId;

    @ApiModelProperty("是否生成采购结算对账单0:未生成,1:已生成")
    private Integer accountFlag;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("销售订单单据ID")
    private Long soDocId;

    @ApiModelProperty("销售订单单据明细ID")
    private Long soDocDid;

    @ApiModelProperty("销售订单单据编号")
    private String soDocNo;

    @ApiModelProperty("销售订单来源单据行号")
    private Integer soDocLineNo;

    @ApiModelProperty("单据日期")
    private LocalDateTime relateDocDate;

    @ApiModelProperty("收发货单编码")
    private String relateDocNo;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("收发货单行号")
    private BigDecimal relateDocLine;

    @ApiModelProperty("关联单据类别2")
    private String relateDoc2Cls;

    @ApiModelProperty("订/退单编码")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据明细2ID")
    private Long relateDoc2Did;

    @ApiModelProperty("订/退单行号")
    private BigDecimal relateDoc2Line;

    @ApiModelProperty("商品SKU类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("原外币不含税单价")
    private BigDecimal originCurrNetPrice;

    @ApiModelProperty("原外币含税单价")
    private BigDecimal originCurrPrice;

    @ApiModelProperty("对账单编号")
    private String docNo;
}
