package com.elitesland.yst.production.pur.dto.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 采购订单(PurPoParamDTO)实体类
 *
 * @author tina.he
 * @since 2021-12-17 10:04:45
 */


@Data
@ApiModel(value = "PurPoParamDTO", description = "采购订单")
public class PurPoParamDTO implements Serializable {

    private static final long serialVersionUID = -7893604349946689125L;

    @ApiModelProperty("采购订单编号")
    String docNo;

    @ApiModelProperty("批次号")
    String finBatchNumber;

    @ApiModelProperty("回传凭证号")
    String finVoucherNo;

    @ApiModelProperty("传输状态(财务批次同步状态)")
    String syncStatus;

    @ApiModelProperty("传输时间")
    LocalDateTime syncTime;

    @ApiModelProperty("失败原因")
    String syncFailReason;
}
