package com.elitesland.yst.production.pur.dto.po;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购订单(PurPo)实体类
 *
 * @author liuqi
 * @since 2020-07-21 10:04:47
 */


@Data
@ApiModel(value = "pur_po", description = "采购订单")
public class PurPoParamVO extends  AbstractExportQueryParam {
    private static final long serialVersionUID = -31691256281311186L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("组织ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> buIds;

    /**
     * 事业部ID
     */
    @ApiModelProperty("事业部ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bdId;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 采购场景类型
     */
    @ApiModelProperty("采购场景类型")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sceneTypeId;
    private List<Long> sceneTypeIds;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;
    /**
     * 采购来源
     */
    @ApiModelProperty("采购来源")
    private String poSource;
    private List<String> poSources;
    /**
     * zhao.zhi.hao
     * 表设计更改添加字段
     */
    /**
     * 供应商联系人
     */
    @ApiModelProperty("供应商联系人")
    String suppContactName;
    /**
     * 供应商联系电话
     */
    @ApiModelProperty("供应商联系电话")
    String suppContactTel;
    /**
     * 供应商联系人邮箱
     */
    @ApiModelProperty("供应商联系人邮箱")
    String suppContactEmail;
    /**
     * 是否团内
     */
    @ApiModelProperty("是否团内")
    private String innerType;
    /**
     * 采购场景编号
     */
    @ApiModelProperty("采购场景编号")
    private String sceneCode;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据编号2
     */
    @ApiModelProperty("单据编号2")
    private String docNo2;
    /**
     * 单据类型 [UDC]PUR:PO_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:PO_TYPE")
    private String docType;
    /**
     * 单据类型2 [UDC]PUR:PO_TYPE2
     */
    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    private String docType2;
    /**
     * 业务类型 [UDC]PUR:BUSS_TYPE
     */
    @ApiModelProperty("业务类型 [UDC]PUR:BUSS_TYPE")
    private String bussType;
    /**
     * 单据类型3
     */
    @ApiModelProperty("单据类型3")
    private String docType3;
    /**
     * 单据状态 [UDC]PUR:PO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:PO_STATUS")
    private String docStatus;
    private List<String> docStatuses;
    /**
     * 单据状态2
     */
    @ApiModelProperty("单据状态2")
    private String docStatus2;
    /**
     * 单据状态3
     */
    @ApiModelProperty("单据状态3")
    private String docStatus3;
    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态")
    ProcInstStatus procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    /**
     * 审批人ID
     */
    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;
    /**
     * 审批意见
     */
    @ApiModelProperty("审批意见")
    private String apprComment;
    /**
     * 订单时间
     */
    @ApiModelProperty("订单时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDateTime docTime;
    @ApiModelProperty("订单时间开始")
    private LocalDateTime docTimeFrom;
    @ApiModelProperty("订单时间结束")
    private LocalDateTime docTimeTo;
    /**
     * 暂挂原因码 [UDC]PUR:PO_HOLD_REASON
     */
    @ApiModelProperty("暂挂原因码 [UDC]PUR:PO_HOLD_REASON")
    private String holdReasonCode;
    /**
     * 暂挂时间
     */
    @ApiModelProperty("暂挂时间")
    private LocalDateTime holdTime;
    /**
     * 暂挂描述
     */
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;
    /**
     * 采购员员工ID
     */
    @ApiModelProperty("采购员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> agentEmpIds;
    /**
     * 跟单员员工ID
     */
    @ApiModelProperty("跟单员员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long merchEmpId;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("区域编码集合")
    private List<String> regions;
    /**
     * 要求部门
     */
    @ApiModelProperty("要求部门")
    private String reqDept;
    /**
     * 项目号
     */
    @ApiModelProperty("项目号")
    private String projNo;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 采购方式
     */
    @ApiModelProperty("采购方式")
    private String poMode;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 是否需要预付款
     */
    @ApiModelProperty("是否需要预付款")
    private Integer needPrepayFlag;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 是否含税
     */
    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税总金额
     */
    @ApiModelProperty("含税总金额")
    private BigDecimal amt;
    /**
     * 未税总金额
     */
    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private Double qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private Double qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private Double netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private Double grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private Double volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 付款条款
     */
    @ApiModelProperty("付款条款")
    private String paymentTerm;
    /**
     * MOQID
     */
    @ApiModelProperty("MOQID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long moqId;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 延交状态
     */
    @ApiModelProperty("延交状态")
    private String overdueStatus;
    /**
     * 收货状态
     */
    @ApiModelProperty("收货状态")
    private String recvStatus;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private Double demandFreshPercent;
    /**
     * 要求效期天数
     */
    @ApiModelProperty("要求效期天数")
    private Integer demandAapDays;
    /**
     * 原始交期
     */
    @ApiModelProperty("原始交期")
    private LocalDateTime origDate;
    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDateTime demandDate;
    @ApiModelProperty("要求日期开始")
    private LocalDateTime demandDateFrom;
    @ApiModelProperty("要求日期结束")
    private LocalDateTime demandDateTo;
    /**
     * 供应商承诺交期
     */
    @ApiModelProperty("供应商承诺交期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDateTime promiseDate;
    private LocalDateTime promiseDateFrom;
    private LocalDateTime promiseDateTo;
    /**
     * 要求供应商确认时间
     */
    @ApiModelProperty("要求供应商确认时间")
    private LocalDateTime demandConfirmTime;
    /**
     * 供应商回签状态
     */
    @ApiModelProperty("供应商回签状态")
    private String suppSignStatus;
    /**
     * 供应商确认时间
     */
    @ApiModelProperty("供应商确认时间")
    private LocalDateTime suppConfirmTime;
    /**
     * 供应商确认用户ID
     */
    @ApiModelProperty("供应商确认用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppConfirmUserid;
    /**
     * 供应商反馈
     */
    @ApiModelProperty("供应商反馈")
    private String suppRemark;
    /**
     * 发运类型
     */
    @ApiModelProperty("发运类型")
    private String shipmentType;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;
    /**
     * 运输温层 [UDC]INV:TRANSPORT_TEMP
     */
    @ApiModelProperty("运输温层 [UDC]INV:TRANSPORT_TEMP")
    private String transportTemp;
    /**
     * 收货仓库ID
     */
    @ApiModelProperty("收货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 收货仓库联系人
     */
    @ApiModelProperty("收货仓库联系人")
    private String whContactName;
    /**
     * 收货仓库联系人电话
     */
    @ApiModelProperty("收货仓库联系人电话")
    private String whContactTel;
    /**
     * 收货仓库联系人邮箱
     */
    @ApiModelProperty("收货仓库联系人邮箱")
    private String whContactEmail;
    /**
     * 交货要求
     */
    @ApiModelProperty("交货要求")
    private String shipmentInstruct;
    /**
     * 交货要求2
     */
    @ApiModelProperty("交货要求2")
    private String shipmentInstruct2;
    /**
     * 发运地址号
     */
    @ApiModelProperty("发运地址号")
    private Integer shipmentAddrNo;
    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;
    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;
    /**
     * 发运联系人邮箱
     */
    @ApiModelProperty("发运联系人邮箱")
    private String shipmentContactEmail;
    /**
     * 发运国家
     */
    @ApiModelProperty("发运国家")
    private String shipmentCountry;
    /**
     * 发运省
     */
    @ApiModelProperty("发运省")
    private String shipmentProvince;
    /**
     * 发运市
     */
    @ApiModelProperty("发运市")
    private String shipmentCity;
    /**
     * 发运区县
     */
    @ApiModelProperty("发运区县")
    private String shipmentCounty;
    /**
     * 发运乡镇街道
     */
    @ApiModelProperty("发运乡镇街道")
    private String shipmentStreet;
    /**
     * 发运详细地址
     */
    @ApiModelProperty("发运详细地址")
    private String shipmentDetailaddr;
    /**
     * 承运商供应商ID
     */
    @ApiModelProperty("承运商供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppId;
    /**
     * 承运商
     */
    @ApiModelProperty("承运商")
    private String carrier;
    /**
     * 从地点 [UOM]COM:CITY
     */
    @ApiModelProperty("从地点 [UOM]COM:CITY")
    private String fromLoc;
    /**
     * 到地点 [UOM]COM:CITY
     */
    @ApiModelProperty("到地点 [UOM]COM:CITY")
    private String toLoc;
    /**
     * 收货单位ID
     */
    @ApiModelProperty("收货单位ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long acceptOuId;
    /**
     * 到达港口 [UDC]COM:TP_PORT
     */
    @ApiModelProperty("到达港口 [UDC]COM:TP_PORT")
    private String recvPort;
    /**
     * 收货地址
     */
    @ApiModelProperty("收货地址")
    private String recvAddr;
    /**
     * 退货地址
     */
    @ApiModelProperty("退货地址")
    private String returnAddr;
    /**
     * 是否加急
     */
    @ApiModelProperty("是否加急")
    private Integer urgentFlag;
    /**
     * 是否允许早交
     */
    @ApiModelProperty("是否允许早交")
    private Integer allowAheadFlag;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private Double recvTolerance;
    /**
     * 收货允差2
     */
    @ApiModelProperty("收货允差2")
    private Double recvTolerance2;
    /**
     * 采购申请ID
     */
    @ApiModelProperty("采购申请ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long prId;
    /**
     * 采购申请单号
     */
    @ApiModelProperty("采购申请单号")
    private String prNo;
    /**
     * 采购计划ID
     */
    @ApiModelProperty("采购计划ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ppId;
    /**
     * 采购计划版本号
     */
    @ApiModelProperty("采购计划版本号")
    private String ppVersoin;
    /**
     * 合同ID
     */
    @ApiModelProperty("合同ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long contractId;
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    private String contractNo;
    /**
     * 供方合同号
     */
    @ApiModelProperty("供方合同号")
    private String suppContractNo;
    /**
     * 供方单号
     */
    @ApiModelProperty("供方单号")
    private String suppDocNo;
    /**
     * 采购RMA_ID
     */
    @ApiModelProperty("采购RMA_ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long prmaId;
    /**
     * 取消数量
     */
    @ApiModelProperty("取消数量")
    private Double cancelQty;

    @ApiModelProperty("取消日期From")
    private LocalDateTime cancelTimeFrom;

    @ApiModelProperty("取消日期To")
    private LocalDateTime cancelTimeTo;
    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long cancelUserId;
    /**
     * 关闭日期
     */
    @ApiModelProperty("关闭日期")
    private LocalDateTime closeDate;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭用户ID
     */
    @ApiModelProperty("关闭用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long closeUserId;
    /**
     * 完成状态
     */
    @ApiModelProperty("完成状态")
    private String completeStatus;
    /**
     * 关联单据类别 来源销售单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 来源销售单等。[UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;

    /**
     * 关联2编号-明细
     */
    @ApiModelProperty("关联2编号-明细")
    private String relate2DNo;
    /**
     * 备注2 货柜
     */
    @ApiModelProperty("备注2 货柜")
    private String remark2;
    /**
     * 是否走接口
     */
    @ApiModelProperty("是否走接口")
    private Boolean intfFlag;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    //页面查询list属性
    @ApiModelProperty("公司ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty("仓库ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("品牌")
    private List<String> brands;

    @ApiModelProperty("商品ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;

    @ApiModelProperty("供应商ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> suppIds;

    @ApiModelProperty("ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    /**
     * zhao.zhi.hao 2020-11-17 13:24:28
     * 前端可输可选组件多字段查询关键字
     */
    @ApiModelProperty("多字段查询关键字")
    String multiKeywords;

    @ApiModelProperty("供应商确认状态")
    private String suppConfirmStatus;

    @ApiModelProperty("来源单据编号集合")
    List<String> docNoList;

    @ApiModelProperty("批次号")
    String finBatchNumber;

    @ApiModelProperty("回传凭证号")
    String finVoucherNo;

    @ApiModelProperty("传输状态(财务批次同步状态)")
    String syncStatus;

    @ApiModelProperty("传输时间")
    LocalDateTime syncTime;
    @ApiModelProperty("传输时间开始")
    private LocalDateTime syncTimeFrom;
    @ApiModelProperty("传输时间结束")
    private LocalDateTime syncTimeTo;

    @ApiModelProperty("失败原因")
    String syncFailReason;
    @ApiModelProperty("是否已申请预付：1是，0否")
    private Boolean prepayFlag;
    @ApiModelProperty("单据类别")
    private String docCls;
}
