package com.elitesland.yst.production.pur.dto.supp;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @date 2020/7/7
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("地址号申请的具体地址信息")
public class PurAddrApplyAddressRpcSaveVO extends CustomFieldBaseModelVo implements Serializable {


    @ApiModelProperty("业务联系人姓名")
    String contPerson;

    @ApiModelProperty("业务联系人手机")
    String mobile;

    @ApiModelProperty("公司电话(电话)")
    String tel;

    @ApiModelProperty("传真")
    String fax;

    @ApiModelProperty("邮箱(电邮)")
    String email;

    @ApiModelProperty("国家")
    String country;

    @ApiModelProperty("省")
    String province;

    @ApiModelProperty("市")
    String city;

    @ApiModelProperty("区县")
    String county;

    @ApiModelProperty("联系地址(详细地址)")
    String detailAddr;

    @ApiModelProperty("是否默认")
    Boolean defaultFlag;

    @ApiModelProperty("地址类型 [UDC]ORG:ADDRESS_TYPE")
    String addressType;

    @ApiModelProperty("邮编")
    String zipCode;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("主表业务类型")
    String masDocCls;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("行号")
    Integer lineNo;

    @ApiModelProperty("微信号")
    private String weChatNo;

    @ApiModelProperty("qq号")
    private String qqNo;

    @ApiModelProperty("数据来源")
    private String dataSource;

}
