package com.elitesland.yst.production.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmScustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustSaveVO;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4 13:17
 */
public interface CrmScustService {

    /**
     * 潜在客户信息分页查询
     *
     * @param searchParam 客户信息分页查询入参
     * @return 潜在客户分页查询信息
     */
    PagingVO<CrmScustPageRespVO> search(CrmScustQueryParamVO searchParam);

    /**
     * 批量分配业务员
     *
     * @param crmEmpAssignParamVO 分配业务员入参
     *
     */
    void empAssign(CrmEmpAssignParamVO crmEmpAssignParamVO);

    /**
     * 潜在客户信息保存
     *
     * @param saveVO 潜在客户信息入参
     * @return 客户id
     */
    ApiResult<CrmScustDetailRespVO> save(CrmScustSaveVO saveVO);

    /**
     * 潜在客户信息查询明细
     *
     * @param id 潜在客户id
     * @return 潜在客户信息
     */
    CrmScustDetailRespVO findScustById(Long id);

    /**
     * 潜在客户状态更新
     *
     * @param id 潜在客户id
     * @return 潜在客户id
     */
    Long updateScustStatus(Long id);

    ApiResult<Object> conScustImportData(List<CrmScustImportSaveVO> parseData);
}
