package com.elitesland.yst.production.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionBatchParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleImportVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalCommissionRuleVO;

import java.util.List;

/**
 * <p>
 * 提成规则业务接口
 * </p>
 *
 * @author Shadow
 * @since 2021-11-22 17:49:39
 */
public interface SalCommissionRuleService {

    /**
     * 查询规则的详情
     * @param id 规则id
     * @return 规则详情
     */
    ApiResult<SalCommissionRuleVO> findIdOne(Long id);

    /**
     * 分页查询
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<SalCommissionRuleVO> search(SalCommissionRuleParam queryParam);

    /**
     * 创建
     *
     * @param creatParam 对象
     */
    Long createOne(SalCommissionRuleCreateParam creatParam);

    /**
     * 批量创建
     *
     * @param param 批量创建参数
     */
    void createBatch(SalCommissionBatchParam param);

    /**
     * 更新
     *
     * @param updateParam 对象
     */
    void update(SalCommissionBatchParam updateParam);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

    /**
     * 批量删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 导入数据
     * @param importData 数据
     */
    void importData(List<SalCommissionRuleImportVO> importData);

}


