package com.elitesland.yst.production.sale.api.service.shop;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponIndexImgVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponOrderVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouPonIndexShowVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCouponSaveVO;

import java.util.List;

/**
 * <p>
 * 优惠卷业务接口
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:07:11
 */
public interface BipCouponService {

    /**
     * 查修优惠券背景图
     *
     * @return
     */
    BipCouponIndexImgVO searchBackImg();

    Long delBackImg();

    /**
     * 保存优惠券背景图
     *
     * @return
     */
    Long saveBackImg(BipCouponIndexImgVO bipCouponIndexImgVO);

    /**
     * 查询当前用户可以领取的优惠券
     *
     * @return
     */
    BipCouPonIndexShowVO findHomeCoupon();

    BipCouPonIndexShowVO findCouponIndexShow();

    /**
     * 删除
     *
     * @param ids
     */
    void delCoupon(List<Long> ids);

    /**
     * 优惠券禁用
     */
    void disableCoupon(List<Long> ids);

    /**
     * 优惠券激活
     *
     * @param ids
     */
    void activeCoupon(List<Long> ids);


    /**
     * 优惠券激活前面的操作判断激活的优惠券里面的商品是否有已经存在的
     * @param ouId
     * @param couponId
     * @return
     */
    Boolean checkRepeatCouponItem(Long ouId,Long couponId);

    /**
     * 通过ID查详情
     *
     * @param id
     * @return
     */
    BipCouponSaveVO findById(Long id);


    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<BipCouponVO> search(BipCouponQueryParamVO queryParam);

    PagingVO<BipCouponVO> searchAll(BipCouponQueryParamVO queryParam);

    /**
     * 排序查询 1.生效时间排序 2.失效时间排序 3.金额排序
     *
     * @return 优惠卷
     */
    PagingVO<BipCouponVO> sortingSearch(BipCouponOrderVO param);

    /**
     * 创建
     *
     * @param creatParam 对象
     */
    Long createOne(BipCouponSaveVO creatParam);

    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<BipCouponSaveVO> List);

    /**
     * 更新
     *
     * @param updateParam 对象
     */
    void update(BipCouponSaveVO updateParam);

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

}
