package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.vo.param.com.SmsVerifyCodeParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCustUserBindPageQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBindCheckRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBindPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCustUserBindSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCustUserRegisterSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
public interface BipCustUserBindService {

    /**
     * app端用户注册
     *
     * @param registerSaveVO 注册信息
     * @return 用户ID
     */
    ApiResult<Long> saveRegister(BipCustUserRegisterSaveVO registerSaveVO);

    /**
     * 保存绑定关系
     *
     * @param saveVO 绑定关系
     * @return 绑定的记录ID
     */
    ApiResult<Long> saveBind(BipCustUserBindSaveVO saveVO);

    /**
     * 根据用户ID获取所属客户ID
     *
     * @param userId 用户ID
     * @return 客户ID
     */
    ApiResult<Long> getCustIdByUserId(Long userId);

    /**
     * 获取用户绑定的客户信息
     *
     * @param userId 用户ID
     * @return 客户信息
     */
    ApiResult<CustDTO> getCustOfUserBind(Long userId);

    /**
     * 发送绑定的短信验证码
     *
     * @param paramVO 发送短信参数
     * @return 是否发送成功
     */
    ApiResult<Boolean> sendSmsVerifyCodeForBind(SmsVerifyCodeParamVO paramVO);

    /**
     * (管理端)检索 绑定信息
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<BipCustUserBindPageRespVO> search(BipCustUserBindPageQueryVO queryParam);

    /**
     * 审批
     *
     * @param ids        主键ID 集合
     * @param stateApply 审批状态
     */
    void updateStateApply(List<Long> ids, String stateApply);

    /**
     * 禁用、启用
     *
     * @param ids   主键ID 集合
     * @param state 审批状态
     */
    void updateState(List<Long> ids, String state);

    /**
     * 根据userId 校验当前用户绑定状态
     *
     * @return BipCustUserBindCheckRespVO 校验信息
     */
    BipCustUserBindCheckRespVO checkCustUserBindInfo();
}
