package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.dto.BipItemDTO;
import com.elitesland.yst.production.sale.api.dto.BipItemSkuDTO;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Shadow
 * @since 2021-08-10 15:45:56
 */
public interface BipItemService {

    /**
     * 库存修改
     * <p>
     * 用于管理端调整库存
     *
     * @param skuId BipItemSkuDO.id
     * @param stock 新的库存值
     * @return BipItemSkuDO.id
     */
    ApiResult<Long> updateStock(Long skuId, Integer stock);

    /**
     * 库存更新
     * <p>
     * 用于扣减库存、返还库存，increment大于0表示需要增加，用于返还，increment小于0时表示扣减，用于下单
     *
     * @param skuId     BipItemSkuDO.id
     * @param increment 增量值
     * @return BipItemSkuDO.id
     */
    ApiResult<Long> incrementStock(Long skuId, Integer increment);

    /**
     * 查询商品SKU信息
     *
     * @param skuIds SKU的ID
     * @return SKU信息
     */
    ApiResult<List<BipItemSkuDTO>> querySku(List<Long> skuIds);

    /**
     * 查询商品SKU信息
     * <p>
     * 携带对应的商品信息
     *
     * @param skuIds SKU的ID
     * @return SKU信息
     */
    ApiResult<List<BipItemDTO>> querySkuWithItem(List<Long> skuIds);

    /**
     * 查询商品信息
     * <p>
     * 包含SKU信息
     *
     * @param itemIds 商品ID
     * @return 商品信息
     */
    ApiResult<List<BipItemDTO>> queryItem(List<Long> itemIds);

    /**
     * 查询商品信息
     * <p>
     * 不包含SKU信息
     *
     * @param itemIds 商品ID
     * @return 商品信息
     */
    ApiResult<List<BipItemDTO>> queryItemWithoutSku(List<Long> itemIds);
}


