package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipRotationChartQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipRetationChartVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipRetationChartSaveVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 轮播图业务实现类
 * </p>
 *
 * @author shadow
 * @since 2021-08-11 15:08:49
 */
public interface BipRotationChartService {

    /**
     * 分页查询
     *
     * @param queryParam 分页查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<BipRetationChartVO> search(BipRotationChartQueryParamVO queryParam);

    /**
     * 首页轮播图
     *
     * @return
     */
    List<BipRetationChartVO> homeRotation(Long id);

    /**
     * 根据id，返回对应的
     *
     * @param Id ID
     * @return 对象
     */
    Optional<BipRetationChartVO> findIdOne(Long Id);

    /**
     * 创建
     *
     * @param creatParam 对象
     */
    Long createOne(BipRetationChartSaveVO creatParam);

    /**
     * 更新
     *
     * @param updateParam 对象
     */
    void update(BipRetationChartSaveVO updateParam);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

    /**
     * 批量删除
     *
     * @param list id列表
     */
    void deleteBatch(List<Long> list);

    /**
     * 批量改变轮播图状态
     *
     * @param ids    id列表
     * @param status 状态
     */
    void changeStatus(List<Long> ids, String status);

}