package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 请求参数 - 价格变更申请分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/26 9:29 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "价格变更申请分页查询请求参数")
public class PriSalePriceAlterPagingParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 171255127572136529L;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    private List<Long> idByIC;
    private List<Long> idByIN;

    @ApiModelProperty(value = "申请单号")
    private String docNo;

    @ApiModelProperty(value = "单据类型 [UDC]PRI:SALE_APPLY_TYPE")
    private String docType;

    @ApiModelProperty(value = "申请日期开始")
    private LocalDateTime applyDateFrom;

    @ApiModelProperty(value = "申请日期结束")
    private LocalDateTime applyDateTo;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

}
