package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 请求参数 - 价格变更申请
 *
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/26 3:53 下午
 */
@Data
@ApiModel(description = "价格变更申请请求参数")
public class PriSalePriceAlterSaveParam implements Serializable {
    private static final long serialVersionUID = 2016146229256599946L;

    @ApiModelProperty(value = "申请单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "申请单号")
    private String docNo;

    @ApiModelProperty(value = "申请类型", required = true)
    @NotEmpty(message = "申请类型不得为空")
    private String docType;

    @ApiModelProperty(value = "申请单状态")
    private String docStatus;

    @ApiModelProperty(value = "公司ID", required = true)
    @NotNull(message = "公司不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司本位币")
    private String currCode;

    @ApiModelProperty(value = "区域")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "客户等级")
    private String custGroup;

    @ApiModelProperty("附件信息")
    List<ComSaleFileComVO> fileComVOS;

    @ApiModelProperty(value = "申请单明细行")
    private List<PriSalePriceAlterDSaveParam> details;


    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    /**
     * 是否启用经营目录
     */
    @ApiModelProperty(value = "是否启用经营目录")
    private Integer catalogueFlag;
}
