package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 请求参数 - 价格查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:13 下午
 */
@Data
@ApiModel(description = "价格请求参数")
public class PriSalePriceQueryParam implements Serializable {
    private static final long serialVersionUID = 955965543378950852L;

    @ApiModelProperty(value = "公司ID", required = true)
    @NotNull(message = "公司ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "客户ID", required = true)
    @NotNull(message = "客户ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "货币码", required = true)
    @NotBlank(message = "货币码不得为空")
    private String currCode;

    @ApiModelProperty(value = "商品集合", required = true)
    @NotEmpty(message = "查询商品集合不得为空")
    @Valid
    private List<PriSaleItemQueryParam> items;

    /**
     * 是否直接返回错误标识
     * true：只要存在未查找到价格的商品时，响应非200，msg为错误信息
     * false或不传：存在未查找到价格的商品时，仍然响应200，data中明细有对应错误信息，其他查到价格的商品正常返回
     */
    @ApiModelProperty(value = "未查找到价格，是否直接返回错误，默认不直接返回错误")
    private Boolean failFast;

}
