package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 请求参数 - 合同验收单明细
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 10:13
 */
@Data
@ApiModel(description = "合同验收单明细请求参数")
public class SalAcceptanceDSaveParam implements Serializable {
    private static final long serialVersionUID = -2542599549376224377L;

    @ApiModelProperty(value = "销售订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soId;

    @ApiModelProperty(value = "销售订单号")
    private String soNo;

    @ApiModelProperty(value = "销售订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

    @ApiModelProperty(value = "主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("订单明细行号")
    private BigDecimal soLineNo;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品名称2")
    private String itemName2;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("单价（含税）")
    private BigDecimal price;

    @ApiModelProperty("税率编码")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("订单金额（含税）")
    private BigDecimal amt;

    @ApiModelProperty("本次验收金额(含税)")
    private BigDecimal acAmt;

    @ApiModelProperty("本次验收不含税金额")
    private BigDecimal acNetAmt;

    @ApiModelProperty("本次验收税额")
    private BigDecimal acTaxAmt;

    @ApiModelProperty("本次验收数量(签售数量)")
    private BigDecimal acQty;

}
