package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 请求参数 - 销售合同审批参数
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 8:16 下午
 */
@Data
@ApiModel(description = "销售合同审批参数")
public class SalContractApprParam implements Serializable {

    private static final long serialVersionUID = 6925601216596507110L;

    @ApiModelProperty(value = "合同ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "合同ID不得为空")
    private Long id;

    @ApiModelProperty("审批状态 通过：APPROVED、拒绝：REJECTED")
    @NotBlank(message = "审批状态不得为空")
    private String apprStatus;

    @ApiModelProperty("审批意见")
    private String apprComment;

}
