package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 请求参数 - 销售合同新增-合同明细
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-10 11:08:28
 */
@Data
@ApiModel(description = "销售合同新增，合同明细请求参数")
public class SalContractDSaveParam implements Serializable {

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("客户商品编码")
    private String custItemCode;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("是否供应商直发")
    private Boolean suppFlag;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("未税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("含税价格")
    private BigDecimal price;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率编号")
    private String taxRateDesc;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣不含税额")
    private BigDecimal discNetAmt;

    @ApiModelProperty("运输方式")
    private String transType;

    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("单个净重")
    private BigDecimal signNetWeight;

    @ApiModelProperty("总净重")
    private BigDecimal netWeight;

    @ApiModelProperty("单个毛重")
    private BigDecimal signGrossWeight;

    @ApiModelProperty("总毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("重量单位")
    private String weightUom;

    @ApiModelProperty("单个体积")
    private BigDecimal signVolume;

    @ApiModelProperty("总体积")
    private BigDecimal volume;

    @ApiModelProperty("体积单位")
    private String volumeUom;

    @ApiModelProperty("备注")
    private String remark;

}
