package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 查询参数 - 销售合同
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 8:16 下午
 */
@Data
@ApiModel(description = "销售合同查询请求参数")
public class SalContractQueryParam implements Serializable {

    private static final long serialVersionUID = -5810434266011871787L;

    @ApiModelProperty(value = "合同ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "合同ID集合")
    private List<Long> ids;
    @ApiModelProperty(value = "合同编码集合")
    private List<String> contractNos;

    @ApiModelProperty(value = "合同编码")
    private String contractNo;
    // 是否模糊查询合同编码
    private Boolean fuzzyQueryNo = true;

    @ApiModelProperty(value = "合同名称")
    private String contractName;
    // 是否模糊查询合同名称
    private Boolean fuzzyQueryName = true;

    @ApiModelProperty(value = "合同分类")
    private String contractType;

    @ApiModelProperty(value = "合同状态")
    private String contractStatus;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "OuID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

}
