package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 分页查询参数 - 项目信息分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 8:13 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "项目信息分页查询请求参数")
public class SalProjPagingParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -6309710113252387665L;

    @ApiModelProperty(value = "项目名称")
    private String projName;

    @ApiModelProperty(value = "公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty("客户类型(正式/潜在)")
    private String custType2;

    @ApiModelProperty("项目编号")
    private String projNo;

    @ApiModelProperty("客户编号")
    private String custCode;

}
