package com.elitesland.yst.production.sale.api.vo.param.shop;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 收货地址(BipAddress)实体类
 *
 * @author makejava
 * @since 2021-09-01 14:43:58
 */

@Data
@ApiModel(value = "bip_address", description = "收货地址")
public class BipAddressQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -22213102166495126L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 收货人姓名
     */
    @ApiModelProperty("收货人姓名")
    private String name;
    /**
     * 收货人联系电话
     */
    @ApiModelProperty("收货人联系电话")
    private String tel;
    /**
     * 收货人账户id
     */
    @ApiModelProperty("收货人账户id")
    private Long custAccountId;
    /**
     * 是否默认
     */
    @ApiModelProperty("是否默认")
    private Long isDefault;
    /**
     * 发货地省编码
     */
    @ApiModelProperty("发货地省编码")
    private String pcode;
    /**
     * 发货地市编码
     */
    @ApiModelProperty("发货地市编码")
    private String ccode;
    /**
     * 发货地区（县）编码
     */
    @ApiModelProperty("发货地区（县）编码")
    private String acode;
    /**
     * 发货地区乡编码
     */
    @ApiModelProperty("发货地区乡编码")
    private String scode;
    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detai;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private Object createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private Object modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
     * sec_bu_id
     */
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
     * sec_user_id
     */
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
     * sec_ou_id
     */
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;


}
