package com.elitesland.yst.production.sale.api.vo.param.shop;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/20/16:31
 * @Description:
 */
@Data
public class BipOrderBackParmVO extends AbstractOrderQueryParam implements Serializable {


    private static final long serialVersionUID = 4678488657730102880L;
    @ApiModelProperty("记录id")
    private Long Id;

    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("组织id")
    private Long buId;
    @ApiModelProperty("组织编码")
    private String buCode;
    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("订单主表id")
    private Long orderId;
    @ApiModelProperty("订单主表单号")
    private String orderDocNo;
    @ApiModelProperty("退货单主表单号")
    private String orderBackDocNo;


    @ApiModelProperty("审核时间")
    private LocalDateTime approveTime;

    @ApiModelProperty("签收时间")
    private LocalDateTime signTime;

    @ApiModelProperty("审核拒绝原因")
    private String refuseReason;


    @ApiModelProperty("申请退款金额")
    private BigDecimal applyBackAmt;

    @ApiModelProperty("批准退款金额")
    private BigDecimal approveBackAmt;

    @ApiModelProperty("审批人id")
    private Long approveUserId;

    @ApiModelProperty("审批人姓名")
    private String approveUserName;


    @ApiModelProperty("退货类型")
    private String backType;

    @ApiModelProperty("退款时间")
    private LocalDateTime backPayTime;

    @ApiModelProperty("退货时间")
    private LocalDateTime backTime;

    @ApiModelProperty("是否需要生成工单")
    private Boolean isWorkOrder;

    @ApiModelProperty("寄货人姓名")
    private String shipperName;

    @ApiModelProperty("寄货人电话")
    private String shipperTel;

    @ApiModelProperty("收货人姓名")
    private String receiverName;

    @ApiModelProperty("收货人电话")
    private String receiverTel;


    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("退款原因")
    private String backReason;

    @ApiModelProperty("退款单状态")
    private String status;

    @ApiModelProperty("账号id")
    private String custAccountId;
    @ApiModelProperty("账号名称")
    private String custAccountName;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("物流单号")
    private String logistDocNo;


}
