package com.elitesland.yst.production.sale.api.vo.param.shop;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/07/15:57
 * @Description:
 */
@Data
public class BipOrderDParmVO extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -8903727818938029276L;

    @ApiModelProperty("订单明细id")
    private Long id;

    @ApiModelProperty("商品类型 ITM：ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("订单单号")
    private String orderDocNo;

    @ApiModelProperty("商品id")
    private String itemId;

    @ApiModelProperty("商品id")
    private String itemCode;


    @ApiModelProperty("sku id")
    private String skuId;

    @ApiModelProperty("商品sku 编码")
    private String skuCode;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;


    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("商品图片编码")
    private String itemPicFileCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品标题")
    private String itemTitle;

    @ApiModelProperty("商品品牌id")
    private Long itmeBrandID;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("是否免运费")
    private Boolean freeFare;

    @ApiModelProperty("商品基础价格")
    private BigDecimal baseAmt;

    @ApiModelProperty("商品客户价格")
    private BigDecimal custPrice;


    @ApiModelProperty("商品优惠金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("商品折扣抵消金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("在线支付金额")
    private BigDecimal payOnlineAmt;

    @ApiModelProperty("购买数量")
    private Long buyQty;

    @ApiModelProperty("运费模板id")
    private Long fareTmplId;

    @ApiModelProperty("运费金额")
    private BigDecimal fareAmt;

    @ApiModelProperty("应付金额")
    private BigDecimal payAmt;
    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;

    @ApiModelProperty("计量单位")
    private String uom;


    @ApiModelProperty("订单明细状态")
    private String status;

    @ApiModelProperty("物流id")
    private Long logisId;

    @ApiModelProperty("物流单号")
    private String logisNo;

//
//    @ApiModelProperty("审核时间")
//    private LocalDateTime approveTime;
//
    @ApiModelProperty("签收时间")
    private LocalDateTime signTime;
//
//    @ApiModelProperty("审核拒绝原因")
//    private String refuseReason;
//
//
//    @ApiModelProperty("申请退款金额")
//    private BigDecimal applyBackAmt;
//
//    @ApiModelProperty("批准退款金额")
//    private BigDecimal approveBackAmt;
//
//    @ApiModelProperty("审批人id")
//    private Long approveUserId;
//
//
//    @ApiModelProperty("审批人姓名")
//    private Field.Str approveUserName;
//
//
//    @ApiModelProperty("退货类型")
//    private String backType;
//
//    @ApiModelProperty("退款时间")
//    private LocalDateTime backPayTime;
//
//    @ApiModelProperty("退货时间")
//    private LocalDateTime backTime;
//
//    @ApiModelProperty("是否需要生成工单")
//    private LocalDateTime isWorkOrder;
//
//    @ApiModelProperty("寄货人姓名")
//    private String shipperName;
//
//    @ApiModelProperty("寄货人电话")
//    private String shipperTel;
//
//    @ApiModelProperty("收货人姓名")
//    private String receiverName;
//
//    @ApiModelProperty("收货人电话")
//    private String receiverTel;


    @ApiModelProperty("优惠券id")
    private String couponId;

    @ApiModelProperty("优惠券编码")
    private String couponCode;


    @ApiModelProperty("满减折扣id")
    private Long mktDiscountOffsetId;

    @ApiModelProperty("满减折扣编码")
    private String mktDiscountOffsetCode;

    @ApiModelProperty("满减折扣明细id")
    private Long mktDiscountOffsetDId;


    @ApiModelProperty("满赠折扣id")
    private Long MktDiscountGiftId;

    @ApiModelProperty("满减折扣编码")
    private String MktDiscountGiftCode;

    @ApiModelProperty("满赠折扣明细id")
    private Long MktDiscountGiftDId;

}
