package com.elitesland.yst.production.sale.api.vo.param.taskinfo;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店-明细
 */
@Data
@ApiModel(description = "销售业绩统计-门店-明细")
public class SaleStatisticsStoreDtlQueryVO extends AbstractOrderQueryParam {

    /**
     * 关联id
     */
    @ApiModelProperty("关联id")
    private Long masId;

    /**
     * 层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值
     */
    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    private String level;
    private List<String> levels;

    /**
     * 业务员编码
     */
    @ApiModelProperty("业务员编码")
    private String code;

    /**
     * 业务员名称
     */
    @ApiModelProperty("业务员名称")
    private String name;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;
    @ApiModelProperty("类型集合")
    private List<String> types;

    /**
     * 业务员编码集合
     */
    @ApiModelProperty("业务员编码集合")
    private List<String> codes;

    /**
     * 业务员编码集合
     */
    @ApiModelProperty("业务员编码集合")
    private Long userId;

    /**
     * 关联id
     */
    @ApiModelProperty("关联id集合")
    private List<Long> masIds;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID")
    private List<Long> ids;

    @ApiModelProperty("统计月份(yyyy-MM)")
    private String docMonth;

    @ApiModelProperty("统计时间开始(yyyy-MM-dd HH:mm:ss)")
    private LocalDateTime docTimeStart;
    @ApiModelProperty("统计时间结束(yyyy-MM-dd HH:mm:ss)")
    private LocalDateTime docTimeEnd;




}