package com.elitesland.yst.production.sale.api.vo.resp.crm;

import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author Evin.dong
 * @version 1.0
 * @date 2021/5/24 9:24
 */
@Data
@ApiModel(description = "证照信息列表数据")
public class CrmCustQualifyRespVO {

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long qualifyOuId;

    @ApiModelProperty(value = "证照编号")
    private String qualifyNo;

    @ApiModelProperty(value = "证照类型")
    private String qualifyType;
    private String qualifyTypeName;

    @ApiModelProperty(value = "证照状态")
    private String qualifyStatus;
    private String qualifyStatusName;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "附件")
    private ComSaleFileComVO enclosure;
}
