package com.elitesland.yst.production.sale.api.vo.resp.pri;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/28 9:42 上午
 */
@ApiModel(description = "价格信息返回参数")
@Data
public class PriSalePriceSimpleVO implements Serializable {
    private static final long serialVersionUID = 5345008498858797793L;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "基础价格(含税)")
    private BigDecimal basePrice;
    @ApiModelProperty(value = "基础价格(不含税)")
    private BigDecimal baseNetPrice;

    @ApiModelProperty(value = "客户价格(含税)")
    private BigDecimal custPrice;
    @ApiModelProperty(value = "基础价格(不含税)")
    private BigDecimal custNetPrice;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validFrom;
    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validTo;

}
