package com.elitesland.yst.production.sale.api.vo.resp.pro;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 返回参数 - 销售合同收款计划
 *
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 7:21 下午
 */
@ApiModel(description = "销售合同收款计划分页查询返回参数")
@Data
public class SalContractRecvPageRespVO implements Serializable {

    private static final long serialVersionUID = -7988495247117046710L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("主键ID")
    private Long masId;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("应收金额")
    private BigDecimal arAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("应收日期")
    private LocalDate arDate;

    @ApiModelProperty("录入人")
    private String inputer;

    @ApiModelProperty("录入日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate inputDate;


}
