package com.elitesland.yst.production.sale.api.vo.resp.pro;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 返回参数 - 销售合同查询
 *
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 7:21 下午
 */
@ApiModel(description = "销售合同查询返回参数")
@Data
public class SalContractSimpleRespVO implements Serializable {

    private static final long serialVersionUID = -7988495247117046710L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同类型")
    private String contractType;

    @ApiModelProperty("合同状态")
    private String contractStatus;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("合同版本")
    private Integer contractVersion;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户联系人")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    private String custPicTel;

    @ApiModelProperty("币种")
    private String currCode;

}
