package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/7/13 10:15
 */
@Data
@ApiModel(description = "发货单明细查询出参")
public class RmiDoDVO implements Serializable {
    private static final long serialVersionUID = -355923060471833259L;

    @ApiModelProperty("发货单明细ID")
    private Long id;
    @ApiModelProperty("订单号")
    private String relateDocNo;
    @ApiModelProperty("订单明细ID")
    private Long relateDocDid;
    @ApiModelProperty("订单主表ID")
    private Long relateDocId;
    @ApiModelProperty("订单类型")
    @SysCode(sys = "yst-sale", mod = "SO_TYPE")
    private String relateDocType;
    private String relateDocTypeName;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("发货单号")
    private String docNo;
    @ApiModelProperty("商品id")
    private Long itemId;
    @ApiModelProperty("商品编号")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("商品规格")
    private String itemSpec;
    @ApiModelProperty("计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;
    @ApiModelProperty("实发数量")
    private BigDecimal qty;
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;
    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;
    @ApiModelProperty("签收不含税金额")
    private BigDecimal confirmNetAmt;
    @ApiModelProperty("发货时间")
    private LocalDateTime docTime;
    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;
    @ApiModelProperty("订单数量")
    private BigDecimal soQty;
    @ApiModelProperty("订单含税金额")
    private BigDecimal soAmt;
    @ApiModelProperty("订单不含税金额")
    private BigDecimal soNetAmt;
    @ApiModelProperty("订单税额")
    private BigDecimal soTaxAmt;
    @ApiModelProperty("签收税额")
    private BigDecimal confirmTaxAmt;
    @ApiModelProperty("税率")
    private BigDecimal soTaxRate;
    @ApiModelProperty("对账状态")
    private String soaStatus;
    @ApiModelProperty("币种Code")
    private String currCode;
    @ApiModelProperty("币种Name")
    private String currName;
    @ApiModelProperty("单据类型")
    private BigDecimal docCls;
    @ApiModelProperty(value = "税收分类编码")
    @SysCode(sys = "yst-supp", mod = "TAX_CLASS_CODE")
    private String taxClass;
    @ApiModelProperty(value = "应税物货应税劳务、服务名称")
    private String taxClassName;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("三级名称")
    private String thirdCateName;
}
