package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author JinXK
 * @date 2021/6/9 14:16
 */
@Data
@ApiModel(description = "销售订单明细查询出参")
public class RmiSalSoDVO implements Serializable {
    private static final long serialVersionUID = 8977551984305109647L;

    @ApiModelProperty("销售订单id")
    private Long id;
    @ApiModelProperty("销售明细订单id")
    private Long soDId;
    @ApiModelProperty("销售订单号")
    private String docNo;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("行状态 N(正常) H(暂挂) C(已取消)")
    private String lineStatus;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("商品id")
    private Long itemId;
    @ApiModelProperty("商品编号")
    private String itemCode;
    @ApiModelProperty("商品规格")
    private String itemSpec;
    @ApiModelProperty("公司名称")
    private String ouName;
    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编号")
    private String ouCode;
    @ApiModelProperty("品牌")
    private String itemBrand;
    @ApiModelProperty("品牌名称")
    private String itemBrandName;
    @ApiModelProperty("数量")
    private BigDecimal qty;
    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;
    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("应收款余额")
    private BigDecimal apAmt;
    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("收款中金额")
    private BigDecimal payingAmt;
    @ApiModelProperty("待付款金额")
    private BigDecimal openAmt;
    @ApiModelProperty("已开票金额")
    private BigDecimal invedAmt;
    @ApiModelProperty("开票中金额")
    private BigDecimal invingAmt;
    @ApiModelProperty("待开票金额")
    private BigDecimal noinvAmt;
    @ApiModelProperty("已开票数量")
    private BigDecimal invedQty;
    @ApiModelProperty("开票中数量")
    private BigDecimal invingQty;
    @ApiModelProperty("待开票数量")
    private BigDecimal noinvQty;
    @ApiModelProperty("本次开票数量")
    private BigDecimal applyQty;
    @ApiModelProperty("本次开票金额")
    private BigDecimal applyAmt;
    @ApiModelProperty("下单渠道")
    private String soSource;
    @ApiModelProperty("单据类型")
    private BigDecimal docCls;
    @ApiModelProperty(value = "税收分类编码")
    @SysCode(sys = "yst-supp", mod = "TAX_CLASS_CODE")
    private String taxClass;
    @ApiModelProperty(value = "应税物货应税劳务、服务名称")
    private String taxClassName;
    @ApiModelProperty("每页序号(前端需要)")
    private Integer pageNo;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("三级名称")
    private String thirdCateName;
}
