package com.elitesland.yst.production.sale.api.vo.resp.sal;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 销售合同明细(SalContractD)实体类
 *
 * @author makejava
 * @since 2021-08-16 11:35:41
 */

@Data
@ApiModel(value = "sal_contract_d", description = "销售合同明细")
public class SalContractDVO implements Serializable {
    private static final long serialVersionUID = -48722600926063195L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品名称2
     */
    @ApiModelProperty("商品名称2")
    private String itemName2;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    /**
     * 客户商品编号
     */
    @ApiModelProperty("客户商品编号")
    private String custItemCode;
    /**
     * 是否供应商代发
     */
    @ApiModelProperty("是否供应商代发")
    private Boolean suppFlag;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 含税价格
     */
    @ApiModelProperty("含税价格")
    private BigDecimal price;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    /**
     * 折扣未税额
     */
    @ApiModelProperty("折扣未税额")
    private BigDecimal discNetAmt;
    /**
     * 折扣含税额
     */
    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;
    /**
     * 单个净重
     */
    @ApiModelProperty("单个净重")
    private BigDecimal singleNetWeight;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 单个毛重
     */
    @ApiModelProperty("单个毛重")
    private BigDecimal singleGrossWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 单个体积
     */
    @ApiModelProperty("单个体积")
    private BigDecimal singleVolume;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 运输方式
     */
    @ApiModelProperty("运输方式")
    private String transType;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 基础价格
     */
    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;
    /**
     * sec_bu_id
     */
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
     * sec_user_id
     */
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
     * sec_ou_id
     */
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;
    /**
     * 税率描述
     */
    @ApiModelProperty("税率描述")
    private String taxRateDesc;


}
