package com.elitesland.yst.production.sale.api.vo.resp.sal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 销售合同(SalContract)实体类
 *
 * @author makejava
 * @since 2021-08-16 11:14:04
 */

@Data
@ApiModel(value = "sal_contract", description = "销售合同")
public class SalContractVO implements Serializable {
    private static final long serialVersionUID = 133864767627035884L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    private String contractNo;
    /**
     * 外部合同编号
     */
    @ApiModelProperty("外部合同编号")
    private String contractNo2;
    /**
     * 合同类型
     */
    @ApiModelProperty("合同类型")
    private String contractType;
    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    private String contractStatus;
    /**
     * 合同名称
     */
    @ApiModelProperty("合同名称")
    private String contractName;
    /**
     * 合同版本
     */
    @ApiModelProperty("合同版本")
    private Integer contractVersion;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 合同质保期
     */
    @ApiModelProperty("合同质保期")
    private String guaranteePeriod;
    /**
     * 城市
     */
    @ApiModelProperty("城市")
    private String contractCity;
    /**
     * 交付详细地址
     */
    @ApiModelProperty("交付详细地址")
    private String deliverAddress;
    /**
     * 审批意见
     */
    @ApiModelProperty("审批意见")
    private String apprComment;
    /**
     * 交货时间
     */
    @ApiModelProperty("交货时间")
    private LocalDateTime deliverDate;
    /**
     * 费用承担方 [UDC]SAL:FREIGHT_ON
     */
    @ApiModelProperty("费用承担方 [UDC]SAL:FREIGHT_ON")
    private String feeCarrier;
    /**
     * 产品安装 [UDC]SAL:INSTALL_TYPE
     */
    @ApiModelProperty("产品安装 [UDC]SAL:INSTALL_TYPE")
    private String installFlag;
    /**
     * 签约日期
     */
    @ApiModelProperty("签约日期")
    private LocalDateTime signDate;
    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDateTime beginDate;
    /**
     * 开始日期
     */
    @ApiModelProperty("结束日期")
    private LocalDateTime endDate;
    /**
     * 合同总金额
     */
    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 合同质保金
     */
    @ApiModelProperty("合同质保金")
    private BigDecimal guaranteeAmt;
    /**
     * 是否需要项目验收
     */
    @ApiModelProperty("是否需要项目验收")
    private Boolean projConfirmFlag;
    /**
     * 签约背景
     */
    @ApiModelProperty("签约背景")
    private String signBackground;
    /**
     * 配送方式 [UDC]SAL:SO_DELIVER_METHOD
     */
    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;
    /**
     * 运输温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("运输温层 [UDC]INV:TEMP_TYPE")
    private String transportTemp;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号")
    private String custCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;
    /**
     * 客户联系人
     */
    @ApiModelProperty("客户联系人")
    private String custPic;
    /**
     * 客户联系人电话
     */
    @ApiModelProperty("客户联系人电话")
    private String custPicTel;
    /**
     * 客户地址
     */
    @ApiModelProperty("客户地址")
    private String custAddress;
    /**
     * 签约公司
     */
    @ApiModelProperty("签约公司")
    private String bSignOu;
    /**
     * 签约部门
     */
    @ApiModelProperty("签约部门")
    private String bSignDept;
    /**
     * 销售员
     */
    @ApiModelProperty("销售员")
    private String bSalesman;
    /**
     * 销售员电话
     */
    @ApiModelProperty("销售员电话")
    private String bSalesmanTel;
    /**
     * 签约公司地址
     */
    @ApiModelProperty("签约公司地址")
    private String bAddress;
    /**
     * 丙方编码
     */
    @ApiModelProperty("丙方编码")
    private String cCode;
    /**
     * 丙方名称
     */
    @ApiModelProperty("丙方名称")
    private String cName;
    /**
     * 丙方地址
     */
    @ApiModelProperty("丙方地址")
    private String cAddress;
    /**
     * 丙方联系人
     */
    @ApiModelProperty("丙方联系人")
    private String cContact;
    /**
     * 丙方联系人电话
     */
    @ApiModelProperty("丙方联系人电话")
    private String cContactTel;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String bRegion;
    /**
     * sec_bu_id
     */
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
     * sec_user_id
     */
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
     * sec_ou_id
     */
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;
    /**
     * 来源单据类型
     */
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    private Long rootDocId;
    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;
    /**
     * 来源单据类型
     */
    @ApiModelProperty("来源单据类型")
    private String rootDocCls;

}
