package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author JinXK
 * @date 2021/6/2 14:17
 */
@Data
@ApiModel(description = "销售开票申请明细参数(通用)")
public class SalInvApplydRespVO implements Serializable {
    private static final long serialVersionUID = -8009010834897647163L;
    @ApiModelProperty(value = "主键ID")
    private Long id;

//    @ApiModelProperty(value = "租户ID")
//    private Long tenantId;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "订单ID")
    private Long soId;

    @ApiModelProperty(value = "订单明细ID")
    private Long soDId;

    @ApiModelProperty(value = "订单编号")
    private String soNo;

    @ApiModelProperty(value = "行号")
    private BigDecimal soLineNo;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

//    @ApiModelProperty(value = "商品名称2")
//    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "品牌")
    private String itemBrand;

    @ApiModelProperty(value = "数量")
    private BigDecimal soQty;

    @ApiModelProperty(value = "单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String soUom;
    private String soUomName;

//    @ApiModelProperty(value = "税率编号")
//    private String soTaxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal soTaxRate;

    @ApiModelProperty(value = "税额")
    private BigDecimal soTaxAmt;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal soAmt;

    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;
    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("已开票金额")
    private BigDecimal invedAmt;
    @ApiModelProperty("开票中金额")
    private BigDecimal invingAmt;
    @ApiModelProperty("待开票金额")
    private BigDecimal noinvAmt;
    @ApiModelProperty("已开票数量")
    private BigDecimal invedQty;
    @ApiModelProperty("开票中数量")
    private BigDecimal invingQty;
    @ApiModelProperty("待开票数量")
    private BigDecimal noinvQty;
    @ApiModelProperty("单据类型")
    private String docCls;

    @ApiModelProperty(value = "本次开票数量")
    private BigDecimal applyQty;

    @ApiModelProperty(value = "本次开票金额")
    private BigDecimal applyAmt;

    @ApiModelProperty(value = "本次开票税额")
    private BigDecimal applyTax;

    @ApiModelProperty(value = "对账单ID")
    private Long soaId;

    @ApiModelProperty(value = "对账单明细ID")
    private Long soaDetailId;

    @ApiModelProperty(value = "对账单编号")
    private String soaNo;

    @ApiModelProperty(value = "发货单明细ID")
    private Long dodId;

    @ApiModelProperty(value = "发货单编号")
    private String doDocNo;

    @ApiModelProperty(value = "应税物货应税劳务、服务名称")
    private String taxClassDesc;

    @ApiModelProperty(value = "税收分类编码")
    private String taxClass;

    @ApiModelProperty(value = "本次开票未税金额")
    private BigDecimal applyNetAmt;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;
}
