package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/16 15:01
 */
@ApiModel(description = "支付押金出参")
@Data
public class SalPayDepositRespVO implements Serializable {
    private static final long serialVersionUID = 4672935641350059442L;

    @ApiModelProperty("支付押金订单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("支付押金单号")
    private String docNo;

    @ApiModelProperty("支付押金订单类型 [UDC]SAL:PD_TYPE")
    @SysCode(sys = "yst-sale", mod = "PD_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("客户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("合同编号")
    private String contractCode;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("押金金额")
    private BigDecimal amt;

    @ApiModelProperty("押金金额")
    private BigDecimal openAmt;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("要求支付日期")
    private LocalDateTime demandPaymentDate;

    @ApiModelProperty("预计退还日期")
    private LocalDateTime planReturnDate;

    @ApiModelProperty("实际还款日期")
    private LocalDateTime returnDate;

    @ApiModelProperty("开户银行")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bankId;

    @ApiModelProperty("开户银行name")
    private String bankName;

    @ApiModelProperty("银行支行")
    private String bankCode;

    @ApiModelProperty("银行账户")
    private String bankAcc;

    @ApiModelProperty("客户联系人")
    private String custContactName;

    @ApiModelProperty("客户联系人电话")
    private String custContactTel;

    @ApiModelProperty("申请人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人名字")
    private String applyName;

    @ApiModelProperty("押金单状态 [UDC]SAL:RECEIPT_STATUS")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("审核人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审核人名称")
    private String apprUserName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("押金说明")
    private String depositDescription;

    @ApiModelProperty("销售公司")
    private String ouName;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("支付方式 [UDC]SAL:REFOUND_METHOD")
    @SysCode(sys = "yst-sale", mod = "REFOUND_METHOD")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty("销售区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty("销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

//    @ApiModelProperty("公司ID")
//    @JsonSerialize(using = ToStringSerializer.class)
//    private Long ouId;

    @ApiModelProperty("销售组织名称")
    private String buName;


    @ApiModelProperty("相关单据编号 原始单号(支付押金单号)")
    private String relateDocNo;



}
