package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/19 11:09
 */
@ApiModel(description = "销售报销单明细")
@Data
public class SalQuotationExportVO implements Serializable {
    private static final long serialVersionUID = -4410137605936625870L;

    @ApiModelProperty(value = "公司名称")
    private Long ouId;
    private String ouName;

    @ApiModelProperty(value = "业务员")
    private Long agentEmpId;
    private String agentEmpName;

    @ApiModelProperty(value = "报价单号")
    private String docNo;

    @ApiModelProperty(value = "报价日期2")
    private LocalDateTime quotationDate;

    @ApiModelProperty(value = "报价日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate quotationDate2;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户联系人")
    private String custContactName;

    @ApiModelProperty(value = "客户联系人电话")
    private String custContactTel;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemSpec;

    @ApiModelProperty(value = "数量")
    private Long qty;

    @ApiModelProperty(value = "计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "税率2")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税率")
    private String taxRate2;

    @ApiModelProperty(value = "备注")
    private String remark;

}
