package com.elitesland.yst.production.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 优惠券领取记录
 */
@Data
@ApiModel(value = "BipCouponVO", description = "优惠券领取记录")
public class BipCouponCustVO implements Serializable {

	private static final long serialVersionUID = -731395434231259998L;
	/**
     * id
     */
    @ApiModelProperty("id")
    private Long id;

    /**
     * 优惠券ID
     */
    @ApiModelProperty("优惠券ID")
    private Long couponId;

    /**
     * 优惠券编码
     */
    @ApiModelProperty("优惠券编码")
    private String couponCode;


    /**
     * 优惠券编码
     */
    @ApiModelProperty("优惠券名称")
    private String couponName;

    /**
     * 客户ID
     */
    @ApiModelProperty("用户ID")
    private Long userId;

    /**
     * 客户名称
     */
    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("领取人（客户名称）")
    private String creator;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 优惠券类型 0满减 1立减
     */
    @ApiModelProperty("优惠券类型 0满减 1立减")
    @SysCode(sys = "yst-sale", mod = "COUPON_TYPE")
    private String type;
    private String typeName;

    /**
     * 优惠券使用类型，匹配品类  匹配商品
     */
    @ApiModelProperty("优惠券使用类型，匹配品类  匹配商品")
    @SysCode(sys = "yst-sale", mod = "COUPON_USE_TYPE")
    private String matchType;
    private String matchTypeName;

    /**
     * 满减最低金额
     */
    @ApiModelProperty("满减最低金额")
    private BigDecimal limitAmt;

    /**
     * 优惠金额
     */
    @ApiModelProperty("优惠金额")
    private BigDecimal freeAmt;

    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validStime;

    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validEtime;

    /**
     * 优惠券状态
     */
    @ApiModelProperty("优惠券状态")
    @SysCode(sys = "yst-sale", mod = "COUPON_STATUS")
    private String state;
    private String stateName;

    /**
     * 说明
     */
    @ApiModelProperty("详细信息")
    private String detailInfo;

    /**
     * 未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     */
    @ApiModelProperty("优惠券使用状态")
    @SysCode(sys = "yst-sale", mod = "COUPON_USE_STATUS")
    private String useStatus;
    private String useStatusName;


}
