package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户客户绑定关系-VO
 * </p>
 *
 * @author ssy
 * @since 2021/9/6
 */
@Data
@ApiModel(value = "bip_cust_user_bind", description = "用户客户绑定关系VO")
public class BipCustUserBindPageRespVO implements Serializable {

    private static final long serialVersionUID = 704269093040503019L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户名，登录号")
    private String username;

    @ApiModelProperty("用户手机号码")
    private String mobile;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("税务登记号")
    private String taxRegNo;

    @ApiModelProperty("联系人姓名")
    private String contactName;

    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("所属公司ID")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    private String ouName;

    @ApiModelProperty("程序段显示公司名称")
    private String viewOuName;

    @ApiModelProperty("所属公司来源")
    private String source;

    @ApiModelProperty("业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("申请绑定时间")
    private LocalDateTime timeApply;

    @ApiModelProperty("状态")
    private String state;
    private String stateName;

    @ApiModelProperty("申请状态")
    private String stateApply;
    private String stateApplyName;

    @ApiModelProperty("注册时间")
    private LocalDateTime timeRegister;

    @ApiModelProperty("营业执照的文件标识")
    private String certFileCode;

    @ApiModelProperty("客服电话")
    private String serviceTel;
}
