package com.elitesland.yst.production.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.api.vo.resp.zone.SupportItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
@ApiModel(description = "菜单商品明细")
public class BipHomeDetailVO implements Serializable {
	private static final long serialVersionUID = 6780828469913342481L;
	@ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("菜单ID")
    private Long menuId;

    @ApiModelProperty("所属公司")
    private Long ouId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品规格")
    private String itemAttr;

    @ApiModelProperty("商品条码")
    private String barcode;

    @ApiModelProperty("品牌")
    private String itemBrand;

    @ApiModelProperty("品牌")
    private String itemTitle;

    @ApiModelProperty("商品图片ID")
    private Long mainPicId;

    @ApiModelProperty("商品图片URL")
    private String mainPicUrl;

    @ApiModelProperty("基础价")
    private BigDecimal price;

    @ApiModelProperty("客户价")
    private BigDecimal priceCust;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("商品状态")
    @SysCode(sys = "yst-sale", mod = "ITEM_STATE")
    private String state;
    private String stateName;

    @ApiModelProperty("货币码")
    private String currCode;

    @ApiModelProperty("支撑域商品主表ID")
    private List<SupportItem> supportItems = new ArrayList<>();

}
