package com.elitesland.yst.production.sale.api.vo.resp.shop;


import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 发票明细表(BipInv)实体类
 *
 * @author joker xing
 * @since 2021-09-06 14:06:10
 */

@Data
@ApiModel(value = "bip_inv", description = "发票明细表")
public class BipInvVO implements Serializable {
    private static final long serialVersionUID = -63175438269539864L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 订单ID
     */
    @ApiModelProperty("订单docNo")
    private String docNo;
    /**
     * 订单ID
     */
    @ApiModelProperty("订单ID")
    private Long orderId;
    /**
     * 发票代码
     */
    @ApiModelProperty("发票代码")
    private String invNo;
    /**
     * 发票编码
     */
    @ApiModelProperty("发票编码")
    private String invCode;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invType;
    /**
     * 发票抬头
     */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /**
     * 税号
     */
    @ApiModelProperty("税号")
    private String taxNo;
    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String bank;
    /**
     * 企业地址
     */
    @ApiModelProperty("企业地址")
    private String companyAddress;
    /**
     * 企业电话
     */
    @ApiModelProperty("企业电话")
    private String companyTel;
    /**
     * 银行账户
     */
    @ApiModelProperty("银行账户")
    private String bankAccount;
    /**
     * 所属公司
     */
    @ApiModelProperty("所属公司")
    private String ownedCompany;
    /**
     * 抬头类型
     */
    @ApiModelProperty("抬头类型")
    private String invTitleType;
    /**
     * 开票金额
     */
    @ApiModelProperty("开票金额")
    private BigDecimal totalAmt;
    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custAccountId;
    @ApiModelProperty("发票订单号下的商品明细")
    private List<BipInvItemDTO> bipInvItemDTO;
    /**
     * 下单时间
     */
    @ApiModelProperty("下单时间")
    private LocalDateTime orderTime;
    /**
     * 文件编码list
     */
    @ApiModelProperty("文件编码list")
    private List<String> fileCodes;
    /**
     * 文件编码list
     */
    @ApiModelProperty("发票文件信息list")
    private List<ComSaleFileComVO> files;
    /**
     * 文件编码list
     */
    @ApiModelProperty("图片编码list")
    private List<String> imgCodes;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String status;
    /**
     * 发票状态no
     */
    @ApiModelProperty("发票状态")
    private int statusNo;
    /**
     * 发票流水号
     */
    @ApiModelProperty("发票流水号")
    private String invSerialNum;
    /**
     * 发票创建时间
     */
    @ApiModelProperty("发票创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("是否被红冲 1是 0否")
    private String isRed;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;




}
