package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/24
 */
@Data
@ApiModel(description = "上下架审核商品")
public class BipItemApproveRespVO implements Serializable {
    private static final long serialVersionUID = 2584944359047346463L;

    @ApiModelProperty(value = "商品ID")
    private Long id;

    @ApiModelProperty(value = "上架编码", position = 1)
    private String shelfCode;

    @ApiModelProperty(value = "状态 [UDC]SAL:ITEM_STATE", position = 2)
    private String state;

    @ApiModelProperty(value = "状态名称", position = 2)
    private String stateName;

    @ApiModelProperty(value = "类型，true-上架审核，false-下架审核", position = 3)
    private Boolean shelf;

    @ApiModelProperty(value = "商品ID", position = 4)
    private Long itemId;

    @ApiModelProperty(value = "商品编码", position = 4)
    private String itemCode;

    @ApiModelProperty(value = "商品名称", position = 4)
    private String itemName;

    @ApiModelProperty(value = "一级商品分类名称", position = 5)
    private String categoryName1;

    @ApiModelProperty(value = "二级商品分类名称", position = 6)
    private String categoryName2;

    @ApiModelProperty(value = "三级商品分类名称", position = 7)
    private String categoryName3;

    @ApiModelProperty(value = "所属公司编码", position = 8)
    private String ouCode;

    @ApiModelProperty(value = "所属公司名称", position = 8)
    private String ouName;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮", position = 9)
    private Boolean fareFree;

    @ApiModelProperty(value = "运费模板编号", position = 10)
    private String fareTmplCode;

    @ApiModelProperty(value = "运费模板名称", position = 10)
    private String fareTmplName;

    @ApiModelProperty(value = "创建人", position = 11)
    private String creator;

    @ApiModelProperty(value = "创建时间", position = 12)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "发起审批时间", position = 31)
    private LocalDateTime timeApproveCreate;

    @ApiModelProperty(value = "审批完成时间", position = 32)
    private LocalDateTime timeApproved;

    @ApiModelProperty(value = "审批人名称", position = 33)
    private String approverName;

    @ApiModelProperty(value = "审批意见", position = 34)
    private String approveOpinion;

    @ApiModelProperty(value = "是否审批通过", position = 35)
    private Boolean approved;
}
