package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/23
 */
@Data
@ApiModel(description = "商品SKU信息")
public class BipItemSkuRespVO implements Serializable {
    private static final long serialVersionUID = 7528454952357083318L;

    @ApiModelProperty(value = "SKU记录的ID")
    private Long id;

    @ApiModelProperty(value = "商品名称", position = 1)
    private String itemName;

    @ApiModelProperty(value = "sku编号", position = 2)
    private String skuCode;

    @ApiModelProperty(value = "商品属性", position = 3)
    private List<BipItemSkuAttrRespVO> attrList;

    @ApiModelProperty(value = "包装规格", position = 4)
    private String spec;

    @ApiModelProperty(value = "商品条码", position = 5)
    private String barcode;

    @ApiModelProperty(value = "品牌", position = 6)
    private String brand;

    @ApiModelProperty(value = "批次", position = 7)
    private String batch;

    @ApiModelProperty(value = "物料类型", position = 8)
    private String materiel;

    @ApiModelProperty(value = "物料类型名称", position = 8)
    private String materielName;

    @ApiModelProperty(value = "商品类型", position = 9)
    private String type;

    @ApiModelProperty(value = "商品类型名称", position = 9)
    private String typeName;

    @ApiModelProperty(value = "B端指导价", position = 10)
    private BigDecimal priceGuide;

    @ApiModelProperty(value = "基础价", position = 11)
    private BigDecimal price;

    @ApiModelProperty(value = "是否一件代发", position = 12)
    private Boolean shipOne;

    @ApiModelProperty(value = "供应商", position = 13)
    private String supplier;

    @ApiModelProperty(value = "库存", position = 14)
    private Integer stock;

    @ApiModelProperty(value = "最小起订量", position = 15)
    private Integer limitBuy;

    @ApiModelProperty("是否冻结，true：冻结  false：未冻结")
    private Boolean freeze;
}
