package com.elitesland.yst.production.sale.api.vo.resp.shop;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/07/15:35
 * @Description:
 */
@Data
@ApiModel(value = "BipOrderRespVO", description = "订单")
public class BipOrderRespVO implements Serializable {

    private static final long serialVersionUID = 4741529115489679632L;

    @ApiModelProperty("订单ID")
    private Long id;

    @ApiModelProperty("订单号")
    private String docNo;

    @ApiModelProperty("所属公司id")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    private String ouName;

    @ApiModelProperty("所属组织id")
    private Long buId;

    @ApiModelProperty("所属组织名称")
    private String buName;

    @ApiModelProperty("业务员姓名")
    private Long agentEmpId;

    @ApiModelProperty("业务员姓名")
    private String agentName;

    @ApiModelProperty("运费收费模式")
    private String fareType;

    @ApiModelProperty("退货单号")
    private String backDocNo;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("实付款")
    private BigDecimal payAmt;

    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;

    @ApiModelProperty("订单总金额")
    @JsonSerialize(using = ToStringSerializer.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("商品总金额")
    private BigDecimal itemAmt;

    @ApiModelProperty("运费总金额")
    private BigDecimal fareAmt;

    @ApiModelProperty("运费收费方式")
    private Boolean freeFare;


    @ApiModelProperty("运费最终金额")
    private BigDecimal fareFinalAmt;

    @ApiModelProperty("优惠券抵扣金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("促销抵扣金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("积分抵扣金额")
    private BigDecimal scoreAmt;

    @ApiModelProperty("下单时间")
    private LocalDateTime orderTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime signTime;


    @ApiModelProperty("支付方式Id")
    private String payMethodId;

    @ApiModelProperty("支付方式")
    private String payMethod;

    @ApiModelProperty("支付方式名称")
    private String payMethodName;

    @ApiModelProperty("订单状态")
    private String status;

    @ApiModelProperty("订单状态名称")
    private String statusName;

    @ApiModelProperty("付款状态")
    private String payStatus;

    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty("支付记录ID")
    private String payRecordId;

    @ApiModelProperty("是否开票")
    private String invoice;

    @ApiModelProperty("发票id")
    private Long invoiceId;

    @ApiModelProperty("订单交付id")
    private Long deliveId;

    @ApiModelProperty("订单交付时间")
    private LocalDateTime deliveTime;


    @ApiModelProperty("订单完成时间")
    private LocalDateTime finishTime;

    @ApiModelProperty("是否评价 0 未评价 1 评价")
    private Boolean isEval;

    @ApiModelProperty("订单评价时间")
    private LocalDateTime evalTime;


    @ApiModelProperty("订单交付状态")
    private String deliveStatus;

    @ApiModelProperty("要求发货时间")
    private LocalDateTime demandTime;

    @ApiModelProperty("订单明细")
    private List<BipOrderDRespVO> orderDList;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("优惠券id")
    private Long couponId;

    @ApiModelProperty("优惠券编码")
    private String couponCode;

    @ApiModelProperty("客户收货地址ID")
    private Long adressId;

    @ApiModelProperty("客户收货信息")
    private BipAddressVO bipAddressVO;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("物流评分")
    private String logicEvalScore;

    @ApiModelProperty("服务评分")
    private String serverEvalScore;

    @ApiModelProperty("商品数量")
    private Long totalItemNum;

    @ApiModelProperty("商品数量")
    private Integer offFlag;

    @ApiModelProperty("是否发货")
    private Boolean isSend;

    @ApiModelProperty("是否同步到OMS true 表示同步，false未同步")
    private Boolean syncOms;

    @ApiModelProperty("省")
    private String provinceName;

    @ApiModelProperty("市")
    private String cityName;

    @ApiModelProperty("区")
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailAddr;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("电话")
    private String mobile;

}
