package com.elitesland.yst.production.sale.api.vo.resp.shop.app;

import com.elitesland.yst.production.sale.api.vo.resp.shop.BipGiftVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSpecRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
@Data
@ApiModel(description = "商品详情")
public class BipItemDetailAppRespVO implements Serializable {
    private static final long serialVersionUID = 5168634913533621602L;

    @ApiModelProperty(value = "商品ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "商品中心的商品ID", position = 2)
    private Long itemId;

    @ApiModelProperty(value = "商品图片", position = 3)
    private List<BipItemPicAppRespVO> picList;

    @ApiModelProperty(value = "标题", position = 4)
    private String title;

    @ApiModelProperty(value = "基础价格", position = 5)
    private BigDecimal price;

    @ApiModelProperty(value = "客户价", position = 6)
    private BigDecimal priceCust;

    @ApiModelProperty(value = "月销量", position = 7)
    private Long numSale;

    @ApiModelProperty(value = "相关优惠", position = 11)
    private List<BipItemPromotionAppRespVO> promotionList;

    @ApiModelProperty(value = "SKU属性", position = 12)
    private BipItemAttrAppRespVO attr;

    @ApiModelProperty(value = "参数", position = 13)
    private List<BipItemSpecRespVO> specList;

    @ApiModelProperty(value = "内容详情图片", position = 14)
    private List<BipItemPicAppRespVO> contentPicList;

    @ApiModelProperty(name = "买赠列表" )
    private List<BipGiftVO> giftList;

    @ApiModelProperty(value = "月销量", position = 15)
    private Long numSale90;
}
