package com.elitesland.yst.production.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/13
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "APP端经销商销售业绩详情的出参")
public class StatisticsDealerAppDetailsRespVO implements Serializable {
    private static final long serialVersionUID = 1402876233602607184L;

    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;
    @ApiModelProperty("统计月份(yyyy-MM)")
    private String docMonth;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "业务员名称")
    private String agentEmpName;

    @ApiModelProperty("所有车型分页列表明细数据")
    private PagingVO<SaleStatisticsDealerRespVO> pagingVO;

}
