package com.elitesland.yst.production.sale.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/11/17 10:36
 */
@Data
@ApiModel(description = "合同导入模板")
public class SalContractImportSaveVO implements Serializable {

    private static final long serialVersionUID = -1013593497404401243L;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty("外部合同号")
    private String contractNo2;

    @ApiModelProperty("项目编码")
    private String projCode;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("合同类型")
    private String contractType;

    @ApiModelProperty("合同质保期 数字N年")
    private String guaranteePeriod;

    @ApiModelProperty("费用承担方")
    private String feeCarrier;

    @ApiModelProperty(value = "交货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate deliverDate;

    @ApiModelProperty("产品安装")
    private String installFlag;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty(value = "签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;

    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("是否需要项目验收")
    private Boolean projConfirmFlag;
    private String projConfirmFlagName;

    @ApiModelProperty("合同质保金")
    private BigDecimal guaranteeAmt;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("交付详细地址")
    private String deliverAddress;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户id")
    private Long custId;

    @ApiModelProperty("客户联系人")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    private String custPicTel;

    @ApiModelProperty("城市")
    private String contractCity;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty(value = "签约公司")
    private String signOu;

    @ApiModelProperty(value = "签约公司2")
    private String bSignOu;
    private String bSignOuCode;

    @ApiModelProperty(value = "签约部门")
    private String signDept;

    @ApiModelProperty(value = "签约部门2")
    private String bSignDept;
    private String bSignDeptCode;

    @ApiModelProperty(value = "区域")
    private String region;
    private String bRegion;

    @ApiModelProperty("销售员")
    private String salesman;
    private String bSalesman;

    @ApiModelProperty("销售员电话")
    private String salesmanTel;
    private String bSalesmanTel;

    @ApiModelProperty("签约公司地址")
    private String addressB;
    private String bAddress;

    @ApiModelProperty("丙方编码")
    private String code;
    private String cCode;

    @ApiModelProperty("丙方名称")
    private String name;
    private String cName;

    @ApiModelProperty("丙方联系人")
    private String contact;
    private String cContact;

    @ApiModelProperty("丙方联系人电话")
    private String contactTel;
    private String cContactTel;

    @ApiModelProperty("丙方地址")
    private String addressC;
    private String cAddress;

    @ApiModelProperty("商品编码")
    private String itemCode;

    // 明细部分
    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("行号")
    private Integer lineNo;

    @ApiModelProperty("客户商品编码")
    private String custItemCode;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("商品品牌")
    private String itemBrand;

    @ApiModelProperty("是否供应商直发")
    private Boolean suppFlag;
    private String suppFlagName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("未税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率编号")
    private String taxRateDesc;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣不含税额")
    private BigDecimal discNetAmt;

    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("数量")
    private BigDecimal price;

    @ApiModelProperty("运输方式")
    private String transType;

}
