package com.elitesland.yst.production.sale.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店
 */
@Data
@ApiModel(description = "销售业绩统计-门店")
public class SaleStatisticsStoreSaveVO implements Serializable {

    /**
     *
     */
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String storeName;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    /**
     * 车型
     */
    @ApiModelProperty("车型")
    private String vehicleType;

    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;

}