package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/07/15:57
 * @Description:
 */
@Data
public class BipOrderDSaveVO  implements Serializable {

    private static final long serialVersionUID = -8903727818938029276L;


    @ApiModelProperty("订单明细id")
    private List<Long> cartIds;
    @ApiModelProperty("订单明细父id")
    private Long id;
    @ApiModelProperty("商品类型 ITM：ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("订单明细id")
    private Long pid;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("订单单号")
    private String orderDocNo;

    @ApiModelProperty("商品id")
    private Long itemId;
    @ApiModelProperty("商品中心商品id")
    private Long relateItemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("sku编码")
    private String skuCode;

    @ApiModelProperty("sku编码")
    private Long skuId;

    @ApiModelProperty("允许退货数量")
    private Long allowBackNum;


    @ApiModelProperty("收货地址")
    private Long addressId;


    @ApiModelProperty("商品基础价格")
    private BigDecimal basePrice;
    @ApiModelProperty("商品客户价格")
    private BigDecimal custPrice;

    @ApiModelProperty("商品优惠金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("商品折扣抵消金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("在线支付金额")
    private BigDecimal payOnlineAmt;

    @ApiModelProperty("购买数量")
    private Long buyQty;
    @ApiModelProperty("购买时价格")
    private BigDecimal buyAmt;

    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;


    @ApiModelProperty("订单明细状态")
    private String status;

    @ApiModelProperty("物流id")
    private Long logisId;

    @ApiModelProperty("物流单号")
    private String logisNo;

    @ApiModelProperty("签收时间")
    private LocalDateTime signTime;

    @ApiModelProperty("是否需要生成工单")
    private Boolean isWorkOrder;

    @ApiModelProperty("收货人姓名")
    private String receiverName;

    @ApiModelProperty("收货人电话")
    private String receiverTel;


    @ApiModelProperty("优惠券id")
    private  List<Long> couponIds;

    @ApiModelProperty("优惠券编码")
    private String couponCode;


    @ApiModelProperty("满减折扣id")
    private Long discountOffsetId;

    @ApiModelProperty("满减折扣明细id")
    private Long discountOffsetDId;

    @ApiModelProperty("满减折扣编码")
    private String discountOffsetCode;


    @ApiModelProperty("满减折扣id")
    private Long discountOffsetGiftId;

    @ApiModelProperty("满减折扣明细id")
    private Long discountOffsetGiftDId;

    @ApiModelProperty("满减折扣编码")
    private String discountOffsetGiftCode;

    //zhao.zhi.hao 2021.09.23
    @ApiModelProperty("发票流水号")
    private String invSerialNum;



}
