package com.elitesland.yst.production.sale.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@ApiModel(description = "客户信息")
@Data
public class CrmCustRespDTO implements Serializable {

    private static final long serialVersionUID = -5598555637843017847L;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 客户组
     */
    private String custGroup;

    /**
     * 是否含税
     */
    private String taxInclFlag;

    /**
     * 税码
     */
    private String taxCode;

    /**
     * 税率编号
     */
    private String taxRateNo;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 区域
     */
    private String region;

    /**
     * 币种
     */
    private String custCurr;

    /**
     * 信贷检查类型
     */
    private String creditCheckType;

    /**
     * 账期检查类型
     */
    private String ardaysCheckType;

    /**
     * 信贷额度
     */
    private BigDecimal creditLimit;

    /**
     * 业务员员工ID
     */
    private Long agentEmpId;

    /**
     * 业务员员工编码
     */
    private String agentEmpCode;

    /**
     * 支付条款
     */
    private String paymentTerm;

    /**
     * 公司ID
     */
    private Long ouId;

    /**
     * 公司编号
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    /**
     * 客户编码
     */
    private String custCode;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户简称
     */
    private String custAbbr;

    /**
     * 客户分类
     */
    private String custType;

    /**
     * 客户状态
     */
    private String custStatus;

    /**
     * 大B/小B
     */
    private String custGroup2;

    /**
     * 外部客户编码
     */
    private String custCode2;
}
