package com.elitesland.yst.production.sale.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/8/17 9:50
 */
@Data
public class SalReceiptStatementDTO implements Serializable {

    @ApiModelProperty("收款单表头id")
    Long receiptId;

    @ApiModelProperty("收款结算单表头id")
    Long sourceId;

    @ApiModelProperty("收款单类型")
    String settleType;

    @ApiModelProperty("订单类型")
    String businessType2;

    @ApiModelProperty("收款日期")
    LocalDateTime processTime;

    @ApiModelProperty("下单渠道")
    String orderChannel;

    @ApiModelProperty("组织类型")
    String orgType;

    @ApiModelProperty("销售组织id")
    Long buId;

    @ApiModelProperty("销售组织code")
    String buCode;

    @ApiModelProperty("销售组织姓名")
    String buName;

    @ApiModelProperty("销售业务员ID")
    Long applyEmpId;

    @ApiModelProperty("销售业务员名称")
    String applyName;

    @ApiModelProperty("币种编码")
    String currency;

    @ApiModelProperty("币种名称")
    String currencyName;

    @ApiModelProperty("公司Id")
    Long ouId;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("公司名称")
    String ouName;

    @ApiModelProperty("客户Id")
    Long custId;

    @ApiModelProperty("客户编码")
    String custCode;

    @ApiModelProperty("客户名称")
    String custName;

    @ApiModelProperty("虚拟客户名称")
    String fakeCustName;

    @ApiModelProperty("虚拟客户编码")
    String fakeCustCode;

    @ApiModelProperty("客户属性")
    String contactType;

    @ApiModelProperty("单据状态")
    String state;

    @ApiModelProperty("核对状态")
    String verifyState;

    @ApiModelProperty("创建人Id")
    Long createUserId;

    @ApiModelProperty("创建人名称")
    String creator;

    @ApiModelProperty("备注")
    String remark;

    @ApiModelProperty("收款类型")
    String receiptType;
    String receiptTypeName;

    @ApiModelProperty("收款方式")
    String payMethod;

    @ApiModelProperty("收款日期")
    LocalDateTime applyDate;

    @ApiModelProperty("收款金额")
    BigDecimal amt;

    @ApiModelProperty("订单编号")
    String docNo;

    @ApiModelProperty("合同号")
    String contractCode;

    @ApiModelProperty("收款账号")
    String ouBankAcc;

    @ApiModelProperty("逆向单号")
    String relationNumber;

    @ApiModelProperty(value = "收款流水")
    String receiptSerial;

    @ApiModelProperty("明细列表")
    List<SalReceiptDetailStatementDTO> details;
}
