package com.elitesland.yst.production.sale.dto.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoRespVO
 * @Date2023/2/21 17:04
 */
@Data
@ApiModel("业务员查询返回参数")
public class SalesmanInfoAPPRespDTO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    /**
     * 员工编码
     */
    @ApiModelProperty("员工编码")
    private String code;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    private String fullName;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 类型名称
     */
    @ApiModelProperty("类型名称")
    private String typeName;

    /**
     * 是否启用
     */
    @ApiModelProperty("是否启用")
    private Boolean enabled;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String phone;

    /**
     * 领导ID
     */
    @ApiModelProperty("领导ID")
    private transient Long leaderEmployeeId;

    /**
     * 下属
     */
    @ApiModelProperty("下属")
    private List<SalesmanInfoAPPRespDTO> underlingList;

    /**
     * 下属数量
     */
    @ApiModelProperty("下属数量")
    private Integer underlingNum;

    //private List<EmployeeUnderlingDTO> underlingList;

    /**
     * 是否有下属
     */
    @ApiModelProperty("是否有下属")
    private Boolean hasUnder;

    @ApiModelProperty("当月目标")
    private BigDecimal monthTarget;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;

    /**
     * 是否有下级员工
     *
     * @return 是否有下级员工
     */
    public Boolean getHasUnderling() {
        return underlingList != null && !underlingList.isEmpty();
    }


    @ApiModelProperty("经销商团队汇总订货量")
    private BigDecimal dealerTeamOrderQty;

    @ApiModelProperty("经销商团队汇总出货量")
    private BigDecimal dealerTeamShipQty;

    @ApiModelProperty("门店团队汇总出货量")
    private BigDecimal storeTeamShipQty;

    @ApiModelProperty("经销商我的汇总订货量")
    private BigDecimal dealerMyOrderQty;

    @ApiModelProperty("经销商我的汇总出货量")
    private BigDecimal dealerMyShipQty;

    @ApiModelProperty("门店我的汇总出货量")
    private BigDecimal storeMyShipQty;

    @ApiModelProperty("经销商总量")
    private Long dealerTotalQty;
}
