package com.elitesland.yst.production.sale.dto.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/15 10:48
 */
@ApiModel(description = "客户信息")
@Data
public class CrmCustQualifyRpcSaveDto implements Serializable {

    private static final long serialVersionUID = 2871325862845059060L;

    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long qualifyOuId;

    /**
     * 证照编号
     */
    private String qualifyNo;

    /**
     * 证照类型
     */
    private String qualifyType;

    /**
     * 证照状态
     */
    private String qualifyStatus;

    /**
     * 生效日期
     */
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    private LocalDateTime validTo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 附件
     */
    private ComSaleFileComDto enclosure;
}
