package com.elitesland.yst.production.sale.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.rpc.param.ItemRpcUpdateParam;
import com.elitesland.yst.production.sale.rpc.param.ItmPutawayItemRpcDTO;
import com.elitesland.yst.production.sale.rpc.param.ItmSpuPutawayRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 商品上下架
 *
 * @author : JS
 * @date 2023/03/03 9:53
 */
@FeignClient(name = Application.NAME, path = LmItmPutawayRpcService.URI)
public interface LmItmPutawayRpcService {

    String URI = Application.URI_PREFIX + "/lm/item/putaway";

    /**
     * 发布到上下架信息
     *
     * @param params 参数
     * @return 无
     */
    @PostMapping("/publish")
    ApiResult<Object> publish(@RequestBody List<ItmSpuPutawayRpcDTO> params);

    /**
     * 通过商品id下架
     *
     * @param itemIds 商品id
     * @return 无
     */
    @PostMapping("/soldOutByItemIds")
    ApiResult<Object> soldOutByItemIds(@RequestBody List<Long> itemIds);

    @GetMapping("/findPutawayItemIds")
    ItmPutawayItemRpcDTO findPutawayItemIds();

    /**
     * 通知销售域商品更新
     * @return
     */
    @PostMapping("/notifyItemUpdate")
    ApiResult<Void> notifyItemUpdate(@RequestBody List<ItemRpcUpdateParam> params);

    /**
     * 查询上架商品信息
     * @param skuIds
     * @param desId
     * @return
     */
    @PostMapping("/queryListingItem")
    ApiResult<List<String>> queryListingItem(@RequestBody List<Long> skuIds, @RequestParam("desId") Long desId);
}
